/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.quest;

import java.util.Random;
import lotr.common.LOTRMod;
import lotr.common.LOTRPlayerData;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.fac.LOTRFaction;
import lotr.common.quest.LOTRMiniQuestKill;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class LOTRMiniQuestKillFaction
extends LOTRMiniQuestKill {
    public LOTRFaction killFaction;

    public LOTRMiniQuestKillFaction(LOTRPlayerData pd) {
        super(pd);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74778_a("KillFaction", this.killFaction.codeName());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.killFaction = LOTRFaction.forName(nbt.func_74779_i("KillFaction"));
    }

    @Override
    public boolean isValidQuest() {
        return super.isValidQuest() && this.killFaction != null;
    }

    @Override
    protected String getKillTargetName() {
        return this.killFaction.factionEntityName();
    }

    @Override
    public void onKill(EntityPlayer entityplayer, EntityLivingBase entity) {
        if (this.killCount < this.killTarget && LOTRMod.getNPCFaction((Entity)entity) == this.killFaction) {
            ++this.killCount;
            this.updateQuest();
        }
    }

    public static class QFKillFaction
    extends LOTRMiniQuestKill.QFKill<LOTRMiniQuestKillFaction> {
        private LOTRFaction killFaction;

        public QFKillFaction(String name) {
            super(name);
        }

        public QFKillFaction setKillFaction(LOTRFaction faction, int min, int max) {
            this.killFaction = faction;
            this.setKillTarget(min, max);
            return this;
        }

        @Override
        public Class getQuestClass() {
            return LOTRMiniQuestKillFaction.class;
        }

        @Override
        public LOTRMiniQuestKillFaction createQuest(LOTREntityNPC npc, Random rand) {
            LOTRMiniQuestKillFaction quest = (LOTRMiniQuestKillFaction)super.createQuest(npc, rand);
            quest.killFaction = this.killFaction;
            return quest;
        }
    }
}

